/*
 * ttrimite date de la senzor touch
 * pe GPIO 12, 14, 27
 *
 * primeste de la celalalt x y z de la mouse PS2
 * 
 * */
//https://microcontrollerslab.com/esp32-esp-now-two-way-communication-arduino-ide/

const int touchPin1 = 12; 
const int touchPin2 = 14;
const int touchPin3 = 27;

const int ledPin = 2;
const int threshold = 30;

int touchValue1;
int touchValue2;
int touchValue3;

#include <esp_now.h>
#include <WiFi.h>

#include <Adafruit_SSD1306.h>
#include <Adafruit_GFX.h>
#define OLED_ADDR   0x3C
Adafruit_SSD1306 display(-1);


// REPLACE WITH THE MAC Address of your receiver 
//uint8_t broadcastAddress[] = {0xCC, 0x50, 0xE3, 0xB6, 0x51, 0xEC};
//adresa proprie

uint8_t broadcastAddress[] = {0xCC, 0x50, 0xE3, 0xB6, 0xC7, 0x78};
//adresa partener  CC:50:E3:B6:C7:78

    int s1;
    int s2;
    int s3;

    int x;
    int y;
    int z;

String success;

typedef struct struct_message {
    int s1;
    int s2;
    int s3;
    int x;
    int y; 
    int z; 
} struct_message;

//struct_message Touch;
//trimite spre partener
struct_message Touch;
struct_message dateprimite;
//primeste de la partener
//struct_message primite;

// Callback when data is sent
void data_sent(const uint8_t *mac_addr, esp_now_send_status_t status) {
  Serial.print("\r\nLast Packet Send Status:\t");
  Serial.println(status == ESP_NOW_SEND_SUCCESS ? "Delivery Success" : "Delivery Fail");
  if (status ==0){
    success = " Success";
  }
  else{
    success = " Fail";
  }
}

// Callback when data is received
void data_receive(const uint8_t * mac, const uint8_t *incomingData, int len) {
  memcpy(&dateprimite, incomingData, sizeof(dateprimite));
  Serial.print("Bytes received: ");
  Serial.println(len);
 
  x = dateprimite.x;
  y = dateprimite.y;
  z = dateprimite.z;
    }
 
void setup() {

  Serial.begin(115200);
  pinMode (ledPin, OUTPUT);
  display.begin(SSD1306_SWITCHCAPVCC, OLED_ADDR);
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0,0);
  display.print("P2P Bilat TouchSenz EspNow");
  display.display();
  delay(2000);

  WiFi.mode(WIFI_STA);
  if (esp_now_init() != ESP_OK) {
    Serial.println("Error initializing ESP-NOW");
    return;
  }
  esp_now_register_send_cb(data_sent);
  
  esp_now_peer_info_t peerInfo;
  memcpy(peerInfo.peer_addr, broadcastAddress, 6);
  peerInfo.channel = 0;  
  peerInfo.encrypt = false;       
  if (esp_now_add_peer(&peerInfo) != ESP_OK){
    Serial.println("Failed to add peer");
    return;
  }
  // Register for a callback function that will be called when data is received
  esp_now_register_recv_cb(data_receive);
  }
 
  void loop() {
  getReadings();
  //apelare subrutina citire senzor
 
  Touch.s1 = s1;
  Touch.s2 = s2;
  Touch.s3 = s3;
 
  esp_err_t result = esp_now_send(broadcastAddress, (uint8_t *) &Touch, sizeof(Touch));
   
  if (result == ESP_OK) {
    Serial.println("Sent with success");
  }
  else {
    Serial.println("Error sending the data");
  }
  Display();
  delay(100);
      }

      
void getReadings(){
  //subrutina citire date senzor touch
  s1 = touchRead(touchPin1);
  s2 = touchRead(touchPin2);
  s3 = touchRead(touchPin3);
  
  Serial.print(s1);
  Serial.println(s2);
  Serial.println(s3);
  // check if the touchValue is below the threshold
  // if it is, set ledPin to HIGH
  //if(touchValue < threshold){
    if(s1 < threshold){
    // turn LED on
    digitalWrite(ledPin, HIGH);
    Serial.println(" - LED on");
  }
  else{
    // turn LED off
    digitalWrite(ledPin, LOW);
    Serial.println(" - LED off");
  }
      }

void Display(){
  display.clearDisplay();
  display.setTextSize(2);
  display.setTextColor(WHITE);
  display.setCursor(0, 0);
 
  display.print("x: ");
  display.print(x);
  display.setCursor(0, 20);
  display.print("y: ");
  display.print(y);
  display.print(" z: ");
  display.print(z);
  display.print(" ");
  display.setCursor(55, 42);
  display.setTextSize(1);
  display.print(success);
  display.display();

  /*//optional afisare pe Serial Monitor
  Serial.println("INCOMING READINGS");
  Serial.print("s1erature: ");
  Serial.print(dateprimite.s1);
  Serial.println(" ºC");
  Serial.print("s2idity: ");
  Serial.print(dateprimite.s2);
  Serial.println(" %");
  Serial.println();
  */
}
